import Variant from '@/interfaces/Variant'
import api from '@/utils/api'
import React, { useEffect, useState } from 'react'
import { Table } from 'react-bootstrap';

interface Props {
  productId: number
  setVariantChildValues: React.Dispatch<React.SetStateAction<VariantValue[]>>
  variantChildValues: VariantValue[]
}

interface VariantValue {
  variant_filha_id: number
  valor: string
  referencia: string
}

const VariantChildList: React.FC<Props> = ({ productId, variantChildValues, setVariantChildValues }) => {

  const [variantChildList, setVariantChildList] = useState<Variant[]>([])

  const [selectedVariants, setSelectedVariants] = useState<Variant[]>([])

  const [childType, setChildType] = useState<string>('Cor')


  useEffect(() => {
    const fetchVariantChildList = async () => {
      try {

        const response = await api.get(`variant/many?offset=0&limit=100&productId=${productId}`)
        setVariantChildList(response.data[0])
        console.log(response.data[0])
      } catch (error) {
        console.log(error)
      }

    }
    fetchVariantChildList()
  }, [productId])

  const handleVariantType = (variant: Variant) => {
    if (variant.cor) return 'Cor'
    if (variant.fonte) return 'Fonte'
    if (variant.imagem) return 'Imagem'
    if (!variant.cor && !variant.fonte && !variant.imagem && variant.tipo != 'arquivo') return 'Texto simples'
  }

  const handleVariantSelect = (variant: Variant) => {
    const variantValue: VariantValue = {
      variant_filha_id: variant.id,
      valor: variant.nome,
      referencia: variant.nome
    }

    setVariantChildValues([...variantChildValues, variantValue])
  }

  const handleVariantRemove = (id: number) => {
    setVariantChildValues(variantChildValues.filter(variantValue => variantValue.variant_filha_id !== id))
  }

  useEffect(() => {
    console.log('variantChildValues', variantChildValues)
  }, [variantChildValues])


  return (
    <div className='mt-3'>
      <div>
        <div className='form-check'>
          <label htmlFor="">Cor</label>
          <input onChange={e => { setChildType('Cor'), setVariantChildValues([]) }} className='form-check-input' type="radio" name='childType' disabled={variantChildValues.length > 0} defaultChecked />
        </div>
        <div className='form-check'>
          <label htmlFor="">Imagem</label>
          <input onChange={e => { setChildType('Imagem'), setVariantChildValues([]) }} className='form-check-input' type="radio" name='childType' disabled={variantChildValues.length > 0} />
        </div>
        <div className='form-check'>
          <label htmlFor="">Fonte</label>
          <input onChange={e => { setChildType('Fonte'), setVariantChildValues([]) }} className='form-check-input' type="radio" name='childType' disabled={variantChildValues.length > 0} />
        </div>
        <div className='form-check'>
          <label htmlFor="">Texto simples</label>
          <input onChange={e => { setChildType('Texto simples'), setVariantChildValues([]) }} className='form-check-input' type="radio" name='childType' disabled={variantChildValues.length > 0} />
        </div>
      </div>
      <h6 className='text-center'>Escolha as variações filhas</h6>
      <div className='overflow-scroll' style={{height: '300px'}}>

        <Table className='table table-striped table-bordered'>
          <thead>
            <tr>
              <th></th>
              <th>Nome</th>
              <th>Tipo</th>
            </tr>
          </thead>
          <tbody>
            {variantChildList.filter(item => handleVariantType(item) === childType).map((variant, index) => (
              <tr key={index} className=''>
                <td>
                  {variantChildValues.some(item => item.variant_filha_id === variant.id) ? (
                    <button onClick={e => handleVariantRemove(variant.id)} className='btn btn-danger'>Remover</button>
                  ) : (
                    <button onClick={e => handleVariantSelect(variant)} className='btn btn-primary'>Add +</button>
                  )}
                </td>
                <td>{variant.nome}</td>
                <td>{handleVariantType(variant)}</td>
              </tr>
            ))}
          </tbody>
        </Table>
      </div>
    </div>
  )
}

export default VariantChildList