'use client'

import React, { useEffect, useState } from 'react'
import { Table } from 'react-bootstrap'

import api from '@/utils/api'
import Image from 'next/image';
import Pagination from '../Pagination/Pagination';
import TabVariantsModal from '../TabsVariantsModal/TabVariantsModal';
import Link from 'next/link';
import SearchInput from './../SearchInput/SearchInput';

const ProductList = () => {

  const STORE_ID = process.env.NEXT_PUBLIC_STORE_ID;

  // Search
  const [query, setQuery] = useState<string>();

  const [products, setProducts] = useState<Product[]>([])
  const [currentPage, setCurrentPage] = useState<number>(1);
  const [pagesOnApi, setPagesOnApi] = useState<number>(0);
  const [offset, setOffset] = useState<number>(0);
  const [limit, setLimit] = useState<number>(10);

  // Modal
  const [show, setShow] = useState(false);
  const [modalID, setModalID] = useState<number>();

  useEffect(() => {
    const getProducts = async () => {
      try {
        let url = `/product?offset=${offset}&limit=${limit}&store_id=${STORE_ID}`
        if (query) {
          url += `&search=${query}`
        }
        const response = await api.get(url)
        setProducts(response.data[0])
        setPagesOnApi(response.data[1])
        console.log(response)

      } catch (error) {
        console.log(error)
      }
    }
    getProducts()
  }, [offset, query])


  const handleDelete = async (id: number) => {
    const confirmed = window.confirm(`Tem certeza que deseja remover ${products.find(item => item.id === id)?.nome}?`);

    if (confirmed) {
      try {
        const response = await api.delete(`/product/${id}`)
        setProducts(products.filter((product) => product.id !== id))
        console.log(response)
        setOffset(0)
      } catch (error) {
        console.log(error)
        console.log('Erro ao deletar produto!')
      }
    }
  }

  const handlePageChange = (page: number) => {
    setCurrentPage(page);
    setOffset((page - 1) * limit);
  };

  const handleModal = () => {
    setShow(!show)
  }


  return (
    <div className='w-75'>
      <div className=' bg-light rounded-4 mx-auto p-3'>
        <div className='d-flex justify-content-between py-2'>
          <h3 className='fw-bold'>Lista de Produtos</h3>
          <div>
            <Link href="/custom_product?type=custom" className='btn btn-primary fs-7 me-3'>Criar produto customizado +</Link>
            <Link href='/custom_product?type=description' className='btn btn-primary fs-7 me-3'>Adicionar descrição +</Link>
            <Link href='/custom_product?type=kit' className='btn btn-primary fs-7'>Kit</Link>
          </div>
        </div>
        <SearchInput setQuery={setQuery} />
        <div className='overflow-y-scroll' style={{height: '380px'}}>
          <Table className='table' style={{ border: '1px solid #ccc' }}>
            <thead>
              <tr>
                <th className='text-center'>Produto</th>
                <th className='text-center'>Ações</th>
              </tr>
            </thead>
            <tbody>
              {products.map((product, index) => (
                <tr key={index}>
                  <td className='border-end-0'><Image src={product?.foto} className="me-4" width={90} height={90} alt='' />{product?.nome}</td>
                  <td className='py-3'>
                    <div className='d-flex flex-column'>
                      <button onClick={e => { handleModal(), setModalID(product.id) }} className='btn link-primary text-decoration-underline fs-7 border-0'>Visualizar</button>
                      <button onClick={e => handleDelete(product.id)} className='btn link-danger text-decoration-underline fs-7 border-0'>Remover</button>
                    </div>
                  </td>
                </tr>
              ))}
            </tbody>
          </Table>
        </div>
        {/* Pagination */}
        <Pagination currentPage={currentPage} pagesOnApi={pagesOnApi} onPageChange={handlePageChange} />
      </div>
      {modalID && (
        <TabVariantsModal show={show} onHide={handleModal} id={modalID} />
      )}
    </div>
  )
}

export default ProductList