import React from 'react';
import { Button } from 'react-bootstrap';
import Image from 'next/image';

type PaginationProps = {
    currentPage: number,
    pagesOnApi: number,
    onPageChange: (index: number) => void,
};


const Pagination: React.FC<PaginationProps> = ({ currentPage, pagesOnApi, onPageChange }) => {
    
    const renderPaginationButtons = () => {
        const paginationButtons = [];
        for (let i = 1; i <= pagesOnApi; i++) {
            paginationButtons.push(
                <button
                    key={i}
                    className={`btn ${currentPage === i ? 'active' : ''} fs-7 me-2`}
                    onClick={() => onPageChange(i)}
                >
                    {i}
                </button>
            );
        }
        return paginationButtons;
    };

    return (
        <div className="d-flex justify-content-center mt-3">
            <button
                className={`btn ${currentPage > 1 ? '' : 'disabled'} fs-7 me-2`}
                onClick={() => onPageChange(currentPage - 1)}
                disabled={currentPage === 1}
            >
                <Image src='/svg/chevron-left.svg' width={16} height={16} alt='' />
            </button>
            {renderPaginationButtons()}
            <button
                className={`btn ${currentPage < pagesOnApi ? '' : 'disabled'} fs-7 ms-2`}
                onClick={() => onPageChange(currentPage + 1)}
                disabled={currentPage === pagesOnApi}
            >
                <Image src='/svg/chevron-right.svg' width={16} height={16} alt='' />
            </button>
        </div>
    );
};

export default Pagination;
